/*
 * Decompiled with CFR 0.152.
 */
package de.astranox.simpleprefix;

import de.astranox.simpleprefix.commands.PrefixCommand;
import de.astranox.simpleprefix.handlers.ConfigWatcher;
import de.astranox.simpleprefix.handlers.LuckPermsEventHandler;
import de.astranox.simpleprefix.handlers.PlayerJoinHandler;
import de.astranox.simpleprefix.managers.ConfigManager;
import de.astranox.simpleprefix.managers.GroupManager;
import de.astranox.simpleprefix.managers.LuckPermsWrapper;
import de.astranox.simpleprefix.managers.MigrationManager;
import de.astranox.simpleprefix.managers.PermissionGroupResolver;
import de.astranox.simpleprefix.managers.TabChatManager;
import de.astranox.simpleprefix.managers.TeamManager;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.Scoreboard;

public class SimplePrefix
extends JavaPlugin
implements Listener {
    private LuckPermsWrapper luckPermsWrapper;
    private Scoreboard scoreboard;
    private boolean useLuckPerms = false;
    private ConfigManager configManager;
    private GroupManager groupManager;
    private PermissionGroupResolver permissionGroupResolver;
    private TeamManager teamManager;
    private TabChatManager chatManager;
    private MigrationManager migrationManager;
    private ConfigWatcher configWatcher;
    private LuckPermsEventHandler luckPermsEventHandler;

    public void onEnable() {
        this.initializeLuckPerms();
        this.scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        this.initializeManagers();
        this.loadConfigurations();
        this.registerEvents();
        this.registerCommands();
        this.startWatchers();
        this.initializePlayers();
        if (this.useLuckPerms) {
            this.getLogger().info("SimplePrefix enabled with LuckPerms integration!");
        } else {
            this.getLogger().info("SimplePrefix enabled in permission-based mode!");
            this.getLogger().info("Use permissions: simpleprefix.group.<groupname>");
        }
    }

    public void onDisable() {
        this.stopWatchers();
        this.cleanupTeams();
        this.getLogger().info("SimplePrefix disabled!");
    }

    private void initializeLuckPerms() {
        try {
            Class.forName("net.luckperms.api.LuckPerms");
            this.luckPermsWrapper = new LuckPermsWrapper();
            this.useLuckPerms = true;
            this.getLogger().info("LuckPerms detected! Using LuckPerms for group management.");
        }
        catch (ClassNotFoundException e) {
            this.getLogger().info("LuckPerms not found! Using permission-based group system.");
            this.useLuckPerms = false;
        }
        catch (IllegalStateException e) {
            this.getLogger().warning("LuckPerms found but not loaded yet! Using permission-based group system.");
            this.useLuckPerms = false;
        }
        catch (Exception e) {
            this.getLogger().warning("Error initializing LuckPerms: " + e.getMessage());
            this.getLogger().info("Falling back to permission-based group system.");
            this.useLuckPerms = false;
        }
    }

    private void initializeManagers() {
        this.configManager = new ConfigManager(this);
        this.groupManager = new GroupManager(this, this.luckPermsWrapper, this.useLuckPerms);
        this.permissionGroupResolver = new PermissionGroupResolver(this, this.groupManager);
        this.teamManager = new TeamManager(this, this.luckPermsWrapper, this.scoreboard, this.configManager, this.groupManager, this.permissionGroupResolver, this.useLuckPerms);
        this.chatManager = new TabChatManager(this, this.luckPermsWrapper, this.configManager, this.groupManager, this.permissionGroupResolver, this.useLuckPerms);
        this.migrationManager = new MigrationManager(this, this.groupManager, this.configManager);
    }

    private void loadConfigurations() {
        this.configManager.loadConfigs();
        this.groupManager.loadGroups();
    }

    private void registerEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)this.chatManager, (Plugin)this);
        PlayerJoinHandler joinHandler = new PlayerJoinHandler(this, this.teamManager, this.chatManager, this.configManager);
        this.getServer().getPluginManager().registerEvents((Listener)joinHandler, (Plugin)this);
        if (this.useLuckPerms && this.luckPermsWrapper != null) {
            this.luckPermsEventHandler = new LuckPermsEventHandler(this, this.luckPermsWrapper, this.teamManager, this.chatManager, this.configManager, this.groupManager);
            this.luckPermsEventHandler.register();
        }
    }

    private void registerCommands() {
        PrefixCommand prefixCommand = new PrefixCommand(this, this.configManager, this.groupManager, this.teamManager, this.chatManager, this.migrationManager);
        this.getCommand("simpleprefix").setExecutor((CommandExecutor)prefixCommand);
        this.getCommand("simpleprefix").setTabCompleter((TabCompleter)prefixCommand);
        this.getCommand("sp").setExecutor((CommandExecutor)prefixCommand);
        this.getCommand("sp").setTabCompleter((TabCompleter)prefixCommand);
    }

    private void startWatchers() {
        this.configWatcher = new ConfigWatcher(this, this.configManager, this.groupManager, this.teamManager);
        this.configWatcher.start();
    }

    private void stopWatchers() {
        if (this.configWatcher != null) {
            this.configWatcher.stop();
        }
    }

    private void initializePlayers() {
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.teamManager.updatePlayerTeam(player);
                this.chatManager.updatePlayerListName(player);
            }
        }, 20L);
    }

    private void cleanupTeams() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.teamManager.removePlayerTeam(player);
        }
    }

    public void updateAllPlayers() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.teamManager.updatePlayerTeam(player);
            this.chatManager.updatePlayerListName(player);
        }
    }

    public boolean isUsingLuckPerms() {
        return this.useLuckPerms;
    }

    public LuckPermsWrapper getLuckPermsWrapper() {
        return this.luckPermsWrapper;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public GroupManager getGroupManager() {
        return this.groupManager;
    }

    public PermissionGroupResolver getPermissionGroupResolver() {
        return this.permissionGroupResolver;
    }

    public TeamManager getTeamManager() {
        return this.teamManager;
    }

    public TabChatManager getChatManager() {
        return this.chatManager;
    }

    public MigrationManager getMigrationManager() {
        return this.migrationManager;
    }

    public ConfigWatcher getConfigWatcher() {
        return this.configWatcher;
    }
}

