/*
 * Decompiled with CFR 0.152.
 */
package de.astranox.simpleprefix.commands;

import de.astranox.simpleprefix.SimplePrefix;
import de.astranox.simpleprefix.managers.ConfigManager;
import de.astranox.simpleprefix.managers.GroupManager;
import de.astranox.simpleprefix.managers.MigrationManager;
import de.astranox.simpleprefix.managers.TabChatManager;
import de.astranox.simpleprefix.managers.TeamManager;
import de.astranox.simpleprefix.util.ComponentParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PrefixCommand
implements CommandExecutor,
TabCompleter {
    private final SimplePrefix plugin;
    private final ConfigManager configManager;
    private final GroupManager groupManager;
    private final TeamManager teamManager;
    private final TabChatManager chatManager;
    private final MigrationManager migrationManager;
    private final String prefix;
    private final MiniMessage mm = MiniMessage.miniMessage();
    private final LegacyComponentSerializer legacy = LegacyComponentSerializer.legacyAmpersand();

    public PrefixCommand(SimplePrefix plugin, ConfigManager configManager, GroupManager groupManager, TeamManager teamManager, TabChatManager chatManager, MigrationManager migrationManager) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.groupManager = groupManager;
        this.teamManager = teamManager;
        this.chatManager = chatManager;
        this.migrationManager = migrationManager;
        if (this.isModern()) {
            this.prefix = "<gray>\u300c<gradient:#FFA07A:#FF6B9D>SimplePrefix</gradient><gray>\u300d";
            return;
        }
        this.prefix = "&7\u300c&6SimplePrefix&7\u300d";
    }

    private void sendMM(CommandSender sender, String mini) {
        ComponentParser parser = new ComponentParser(this.plugin);
        sender.sendMessage(parser.parse(mini));
    }

    private void sendPrefix(CommandSender sender, String mini) {
        this.sendMM(sender, this.prefix + " \u00bb " + mini);
    }

    private void header(CommandSender sender, String title) {
        this.sendMM(sender, "&8\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        this.sendMM(sender, " " + title);
        this.sendMM(sender, "&8\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
        sender.sendMessage("");
    }

    private void require(CommandSender sender, String perm) throws NoPermission {
        if (!sender.hasPermission(perm)) {
            this.sendPrefix(sender, "<red>No permission: <white>" + perm);
            throw new NoPermission();
        }
    }

    private void updateAllPlayers() {
        this.plugin.updateAllPlayers();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        try {
            String sub;
            if (!sender.hasPermission("simpleprefix.use")) {
                this.sendPrefix(sender, "<red>No permission: <white>simpleprefix.use");
                return true;
            }
            if (args.length == 0 || args[0].equalsIgnoreCase("help")) {
                this.showHelp(sender);
                return true;
            }
            switch (sub = args[0].toLowerCase(Locale.ROOT)) {
                case "reload": {
                    this.require(sender, "simpleprefix.reload");
                    this.configManager.reloadConfig();
                    this.groupManager.reloadGroups();
                    this.updateAllPlayers();
                    this.sendPrefix(sender, "<green>Configs reloaded successfully!");
                    return true;
                }
                case "update": {
                    this.require(sender, "simpleprefix.update");
                    if (args.length == 1) {
                        this.updateAllPlayers();
                        this.sendPrefix(sender, "<green>All players updated!");
                        return true;
                    }
                    String playerName = args[1];
                    Player p = Bukkit.getPlayerExact((String)playerName);
                    if (p == null) {
                        this.sendPrefix(sender, "<red>Player not found!");
                        return true;
                    }
                    this.teamManager.updatePlayerTeam(p);
                    this.chatManager.updatePlayerListName(p);
                    this.sendPrefix(sender, "<green>Updated player: <white>" + p.getName());
                    return true;
                }
                case "list": {
                    this.require(sender, "simpleprefix.list");
                    this.header(sender, "Groups");
                    Map<String, GroupManager.GroupData> groups = this.groupManager.getAllGroups();
                    for (Map.Entry<String, GroupManager.GroupData> e : groups.entrySet()) {
                        GroupManager.GroupData d = e.getValue();
                        this.sendPrefix(sender, "<yellow>" + e.getKey() + " <gray>(Priority: <white>" + d.priority + "<gray>)");
                        if (d.prefix != null && !d.prefix.isEmpty()) {
                            this.sendMM(sender, "  Prefix: " + d.prefix);
                        }
                        if (d.suffix != null && !d.suffix.isEmpty()) {
                            this.sendMM(sender, "  Suffix: " + d.suffix);
                        }
                        if (d.nameColor == null || d.nameColor.isEmpty()) continue;
                        this.sendMM(sender, "  Name Color: <" + d.nameColor + ">" + d.nameColor);
                    }
                    return true;
                }
                case "create": {
                    this.require(sender, "simpleprefix.create");
                    if (args.length < 3) {
                        this.sendPrefix(sender, "<red>Usage: <white>/" + label + " create <group> <prefix...>");
                        return true;
                    }
                    String groupName = args[1];
                    String prefix = PrefixCommand.join(args, 2);
                    if (groupName.length() > 32) {
                        this.sendPrefix(sender, "<red>Group name too long! Maximum 32 characters.");
                        return true;
                    }
                    if (!groupName.matches("[a-zA-Z0-9_-]+")) {
                        this.sendPrefix(sender, "<red>Invalid group name! Only letters, numbers, - and _ allowed.");
                        return true;
                    }
                    this.header(sender, "Create Group");
                    boolean success = this.groupManager.createGroup(groupName, prefix, "", 999, null);
                    if (!success) {
                        this.sendPrefix(sender, "<red>Failed to create group! Group may already exist.");
                        return true;
                    }
                    this.sendPrefix(sender, "<green>Successfully created group: <white>" + groupName);
                    sender.sendMessage("");
                    this.sendPrefix(sender, "<gray>Prefix: <white>" + prefix);
                    this.sendPrefix(sender, "<gray>Priority: <white>999 <gray>(default)");
                    sender.sendMessage("");
                    if (this.plugin.isUsingLuckPerms()) {
                        this.sendPrefix(sender, "<green>\u2713 Group created in LuckPerms");
                    }
                    this.sendPrefix(sender, "<green>\u2713 Group created in SimplePrefix");
                    sender.sendMessage("");
                    this.sendPrefix(sender, "<gray>Use <white>/" + label + " set " + groupName + " priority <yellow><value><gray> to change priority");
                    this.sendPrefix(sender, "<gray>Use <white>/" + label + " set " + groupName + " suffix <yellow><value><gray> to add suffix");
                    this.sendPrefix(sender, "<gray>Use <white>/" + label + " set " + groupName + " namecolor <yellow><value><gray> to set name color");
                    sender.sendMessage("");
                    if (!this.plugin.isUsingLuckPerms()) {
                        this.sendPrefix(sender, "<yellow>\u2139 Give players permission: <white>simpleprefix.group." + groupName);
                    }
                    this.updateAllPlayers();
                    return true;
                }
                case "delete": {
                    this.require(sender, "simpleprefix.delete");
                    if (args.length < 2) {
                        this.sendPrefix(sender, "<red>Usage: <white>/" + label + " delete <group>");
                        return true;
                    }
                    String groupName = args[1];
                    this.header(sender, "Delete Group");
                    boolean success = this.groupManager.deleteGroupCompletely(groupName);
                    if (!success) {
                        this.sendPrefix(sender, "<red>Failed to delete group! See console for details.");
                        return true;
                    }
                    this.sendPrefix(sender, "<green>Successfully deleted group: <white>" + groupName);
                    if (this.plugin.isUsingLuckPerms()) {
                        this.sendPrefix(sender, "<green>\u2713 Group deleted from LuckPerms");
                    }
                    this.sendPrefix(sender, "<green>\u2713 Group deleted from SimplePrefix");
                    this.updateAllPlayers();
                    return true;
                }
                case "set": {
                    this.require(sender, "simpleprefix.set");
                    if (args.length < 4) {
                        this.sendPrefix(sender, "<red>Usage: <white>/" + label + " set <group> <prefix|suffix|priority|namecolor> <value>");
                        return true;
                    }
                    String group = args[1];
                    String field = args[2].toLowerCase(Locale.ROOT);
                    String value = PrefixCommand.join(args, 3);
                    GroupManager.GroupData current = this.groupManager.getGroup(group);
                    if (current == null) {
                        this.sendPrefix(sender, "<red>Group '<white>" + group + "</white>' not found in LuckPerms!");
                        return true;
                    }
                    String prefix = current.prefix != null ? current.prefix : "";
                    String suffix = current.suffix != null ? current.suffix : "";
                    int priority = current.priority;
                    String nameColor = current.nameColor;
                    switch (field) {
                        case "prefix": {
                            prefix = value;
                            this.groupManager.setGroup(group, prefix, suffix, priority, nameColor);
                            this.updateAllPlayers();
                            this.sendPrefix(sender, "<green>Prefix for group <white>" + group + "</white> set to: <white>" + value);
                            return true;
                        }
                        case "suffix": {
                            suffix = value;
                            this.groupManager.setGroup(group, prefix, suffix, priority, nameColor);
                            this.updateAllPlayers();
                            this.sendPrefix(sender, "<green>Suffix for group <white>" + group + "</white> set to: <white>" + value);
                            return true;
                        }
                        case "priority": {
                            try {
                                priority = Integer.parseInt(value);
                            }
                            catch (NumberFormatException e) {
                                this.sendPrefix(sender, "<red>Priority must be a number between 0 and 999.");
                                return true;
                            }
                            if (priority < 0 || priority > 999) {
                                this.sendPrefix(sender, "<red>Priority must be a number between 0 and 999.");
                                return true;
                            }
                            this.groupManager.setGroup(group, prefix, suffix, priority, nameColor);
                            this.updateAllPlayers();
                            this.sendPrefix(sender, "<green>Priority for group <white>" + group + "</white> set to: <white>" + priority);
                            return true;
                        }
                        case "namecolor": {
                            nameColor = value;
                            this.groupManager.setGroup(group, prefix, suffix, priority, nameColor);
                            this.updateAllPlayers();
                            this.sendPrefix(sender, "<green>Name color for group <white>" + group + "</white> set to: <white>" + value);
                            return true;
                        }
                    }
                    this.sendPrefix(sender, "<red>Unknown field: <white>" + field + "</white> (use prefix|suffix|priority|namecolor)");
                    return true;
                }
                case "clear": {
                    this.require(sender, "simpleprefix.set");
                    if (args.length < 3) {
                        this.sendPrefix(sender, "<red>Usage: <white>/" + label + " clear <group> <prefix|suffix|namecolor>");
                        return true;
                    }
                    String group = args[1];
                    String field = args[2].toLowerCase(Locale.ROOT);
                    GroupManager.GroupData current = this.groupManager.getGroup(group);
                    if (current == null) {
                        this.sendPrefix(sender, "<red>Group '<white>" + group + "</white>' not found in LuckPerms!");
                        return true;
                    }
                    String prefix = current.prefix != null ? current.prefix : "";
                    String suffix = current.suffix != null ? current.suffix : "";
                    int priority = current.priority;
                    String nameColor = current.nameColor;
                    switch (field) {
                        case "prefix": {
                            this.groupManager.setGroup(group, "", suffix, priority, nameColor);
                            this.updateAllPlayers();
                            this.sendPrefix(sender, "<green>Prefix for group <white>" + group + "</white> cleared!");
                            return true;
                        }
                        case "suffix": {
                            this.groupManager.setGroup(group, prefix, "", priority, nameColor);
                            this.updateAllPlayers();
                            this.sendPrefix(sender, "<green>Suffix for group <white>" + group + "</white> cleared!");
                            return true;
                        }
                        case "namecolor": {
                            this.groupManager.setGroup(group, prefix, suffix, priority, null);
                            this.updateAllPlayers();
                            this.sendPrefix(sender, "<green>Name color for group <white>" + group + "</white> cleared!");
                            return true;
                        }
                    }
                    this.sendPrefix(sender, "<red>Unknown field: <white>" + field + "</white> (use prefix|suffix|namecolor)");
                    return true;
                }
                case "save": {
                    this.require(sender, "simpleprefix.save");
                    if (args.length < 2) {
                        this.sendPrefix(sender, "<red>Usage: <white>/" + label + " save <group>");
                        return true;
                    }
                    String group = args[1];
                    this.groupManager.saveToConfig(group);
                    this.sendPrefix(sender, "<green>Group <white>" + group + "</white> saved to config!");
                    return true;
                }
                case "format": {
                    this.require(sender, "simpleprefix.format");
                    if (args.length < 2) {
                        this.sendPrefix(sender, "<red>Usage: <white>/" + label + " format <chat|tab> [set <format...>|toggle]");
                        return true;
                    }
                    String target = args[1].toLowerCase(Locale.ROOT);
                    if (target.equals("chat")) {
                        if (args.length == 2) {
                            this.header(sender, "Chat Format");
                            String format = this.configManager.getChatFormat();
                            boolean enabled = this.configManager.isChatFormatEnabled();
                            this.sendPrefix(sender, "<gray>Status: <white>" + (enabled ? "Enabled" : "Disabled"));
                            this.sendPrefix(sender, "<gray>Format: <white>" + format);
                            return true;
                        }
                        if (args.length >= 3 && args[2].equalsIgnoreCase("set")) {
                            if (args.length < 4) {
                                this.sendPrefix(sender, "<red>Usage: <white>/" + label + " format chat set <format...>");
                                return true;
                            }
                            String format = PrefixCommand.join(args, 3);
                            this.configManager.setChatFormat(format);
                            this.sendPrefix(sender, "<green>Chat format set to: <white>" + format);
                            return true;
                        }
                        if (args.length >= 3 && args[2].equalsIgnoreCase("toggle")) {
                            boolean current = this.configManager.isChatFormatEnabled();
                            this.configManager.setChatEnabled(!current);
                            this.sendPrefix(sender, "<green>Chat format " + (!current ? "enabled" : "disabled") + "!");
                            return true;
                        }
                        this.sendPrefix(sender, "<red>Usage: <white>/" + label + " format chat [set <format...>|toggle]");
                        return true;
                    }
                    if (target.equals("tab")) {
                        if (args.length == 2) {
                            this.header(sender, "Tab Format");
                            String format = this.configManager.getTabFormat();
                            boolean enabled = this.configManager.isTabFormatEnabled();
                            this.sendPrefix(sender, "<gray>Status: <white>" + (enabled ? "Enabled" : "Disabled"));
                            this.sendPrefix(sender, "<gray>Format: <white>" + format);
                            return true;
                        }
                        if (args.length >= 3 && args[2].equalsIgnoreCase("set")) {
                            if (args.length < 4) {
                                this.sendPrefix(sender, "<red>Usage: <white>/" + label + " format tab set <format...>");
                                return true;
                            }
                            String format = PrefixCommand.join(args, 3);
                            this.configManager.setTabFormat(format);
                            this.updateAllPlayers();
                            this.sendPrefix(sender, "<green>Tab format set to: <white>" + format);
                            return true;
                        }
                        if (args.length >= 3 && args[2].equalsIgnoreCase("toggle")) {
                            boolean current = this.configManager.isTabFormatEnabled();
                            this.configManager.setTabEnabled(!current);
                            this.updateAllPlayers();
                            this.sendPrefix(sender, "<green>Tab format " + (!current ? "enabled" : "disabled") + "!");
                            return true;
                        }
                        this.sendPrefix(sender, "<red>Usage: <white>/" + label + " format tab [set <format...>|toggle]");
                        return true;
                    }
                    this.sendPrefix(sender, "<red>Unknown format target: <white>" + target + "</white> (use chat|tab)");
                    return true;
                }
                case "migrate": {
                    this.require(sender, "simpleprefix.migrate");
                    if (args.length < 2 || !args[1].equalsIgnoreCase("luckprefix")) {
                        this.sendPrefix(sender, "<red>Usage: <white>/" + label + " migrate luckprefix");
                        return true;
                    }
                    this.header(sender, "LuckPrefix Migration");
                    this.sendPrefix(sender, "<gray>Starting migration from LuckPrefix...");
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                        MigrationManager.MigrationResult result = this.migrationManager.migrateLuckPrefix();
                        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                            if (!result.success) {
                                this.sendPrefix(sender, "<red>" + result.message);
                                return;
                            }
                            this.sendPrefix(sender, "<green>" + result.message);
                            sender.sendMessage("");
                            if (!result.details.isEmpty()) {
                                this.sendMM(sender, "\u25b8 Migration Details");
                                for (Map.Entry<String, String> e : result.details.entrySet()) {
                                    String status = e.getValue();
                                    String color = status.startsWith("\u2713") ? "<green>" : "<yellow>";
                                    this.sendPrefix(sender, color + " \u2022 " + e.getKey() + " \u2192 " + status);
                                }
                            }
                            sender.sendMessage("");
                            this.sendPrefix(sender, "<gray>Migration complete! Updating all players...");
                            this.updateAllPlayers();
                            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.sendPrefix(sender, "<green>All players updated successfully!"), 20L);
                        });
                    });
                    return true;
                }
                case "cleanup": {
                    this.require(sender, "simpleprefix.cleanup");
                    this.header(sender, "Group Cleanup");
                    this.sendPrefix(sender, "<gray>Cleaning up empty groups...");
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                        MigrationManager.MigrationResult result = this.migrationManager.cleanupEmptyGroups();
                        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                            if (result.migratedCount == 0) {
                                this.sendPrefix(sender, "<yellow>" + result.message);
                                return;
                            }
                            this.sendPrefix(sender, "<green>" + result.message);
                            sender.sendMessage("");
                            if (!result.details.isEmpty()) {
                                this.sendMM(sender, "\u25b8 Removed Groups");
                                for (String groupName : result.details.keySet()) {
                                    this.sendPrefix(sender, "<yellow> \u2022 " + groupName);
                                }
                            }
                            sender.sendMessage("");
                            this.sendPrefix(sender, "<gray>Cleanup complete! Updating all players...");
                            this.updateAllPlayers();
                            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.sendPrefix(sender, "<green>All players updated successfully!"), 20L);
                        });
                    });
                    return true;
                }
            }
            this.showHelp(sender);
            return true;
        }
        catch (NoPermission ignored) {
            return true;
        }
        catch (Throwable t) {
            this.sendPrefix(sender, "<red>An internal error occurred. See console.");
            t.printStackTrace();
            return true;
        }
    }

    private void showHelp(CommandSender sender) {
        this.sendMM(sender, "&8\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        this.sendMM(sender, " " + this.prefix);
        this.sendMM(sender, "&8\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
        sender.sendMessage("");
        this.sendPrefix(sender, "<#FFA07A>/sp reload - Reload configs");
        this.sendPrefix(sender, "<#FFA07A>/sp update [player] - Update teams");
        this.sendPrefix(sender, "<#FFA07A>/sp list - Show all groups");
        this.sendPrefix(sender, "<#FFA07A>/sp create - Create group");
        this.sendPrefix(sender, "<#FFA07A>/sp delete - Delete group");
        this.sendPrefix(sender, "<#FFA07A>/sp migrate luckprefix - Migrate from LuckPrefix");
        this.sendPrefix(sender, "<#FFA07A>/sp cleanup - Remove empty groups");
        sender.sendMessage("");
        this.sendMM(sender, "\u25b8 Group Management");
        this.sendPrefix(sender, "<#FFA07A>/sp set prefix - Set prefix");
        this.sendPrefix(sender, "<#FFA07A>/sp set suffix - Set suffix");
        this.sendPrefix(sender, "<#FFA07A>/sp set priority - Set priority");
        this.sendPrefix(sender, "<#FFA07A>/sp set namecolor - Set name color");
        this.sendPrefix(sender, "<#FFA07A>/sp clear prefix - Clear prefix");
        this.sendPrefix(sender, "<#FFA07A>/sp clear suffix - Clear suffix");
        this.sendPrefix(sender, "<#FFA07A>/sp clear namecolor - Clear name color");
        this.sendPrefix(sender, "<#FFA07A>/sp save - Save to config");
        sender.sendMessage("");
        this.sendMM(sender, "\u25b8 Format Management");
        this.sendPrefix(sender, "<#FFA07A>/sp format chat - Show chat format");
        this.sendPrefix(sender, "<#FFA07A>/sp format chat set - Set format");
        this.sendPrefix(sender, "<#FFA07A>/sp format chat toggle - Toggle chat");
        this.sendPrefix(sender, "<#FFA07A>/sp format tab - Show tab format");
        this.sendPrefix(sender, "<#FFA07A>/sp format tab set - Set format");
        this.sendPrefix(sender, "<#FFA07A>/sp format tab toggle - Toggle tab");
    }

    private static String join(String[] a, int start) {
        if (start >= a.length) {
            return "";
        }
        return String.join((CharSequence)" ", Arrays.copyOfRange(a, start, a.length));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String a0;
        List<String> empty = Collections.emptyList();
        if (!sender.hasPermission("simpleprefix.use")) {
            return empty;
        }
        if (args.length == 1) {
            return PrefixCommand.filter(Arrays.asList("help", "reload", "update", "list", "create", "set", "clear", "delete", "save", "format", "migrate", "cleanup"), args[0]);
        }
        switch (a0 = args[0].toLowerCase(Locale.ROOT)) {
            case "update": {
                if (args.length == 2) {
                    return PrefixCommand.filter(Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getName).collect(Collectors.toList()), args[1]);
                }
                return empty;
            }
            case "create": {
                return empty;
            }
            case "set": {
                if (args.length == 2) {
                    return PrefixCommand.filter(new ArrayList<String>(this.groupManager.getAllGroups().keySet()), args[1]);
                }
                if (args.length == 3) {
                    return PrefixCommand.filter(Arrays.asList("prefix", "suffix", "priority", "namecolor"), args[2]);
                }
                return empty;
            }
            case "clear": {
                if (args.length == 2) {
                    return PrefixCommand.filter(new ArrayList<String>(this.groupManager.getAllGroups().keySet()), args[1]);
                }
                if (args.length == 3) {
                    return PrefixCommand.filter(Arrays.asList("prefix", "suffix", "namecolor"), args[2]);
                }
                return empty;
            }
            case "delete": 
            case "save": {
                if (args.length == 2) {
                    return PrefixCommand.filter(new ArrayList<String>(this.groupManager.getAllGroups().keySet()), args[1]);
                }
                return empty;
            }
            case "format": {
                if (args.length == 2) {
                    return PrefixCommand.filter(Arrays.asList("chat", "tab"), args[1]);
                }
                if (args.length == 3) {
                    return PrefixCommand.filter(Arrays.asList("set", "toggle"), args[2]);
                }
                return empty;
            }
            case "migrate": {
                if (args.length == 2) {
                    return PrefixCommand.filter(Collections.singletonList("luckprefix"), args[1]);
                }
                return empty;
            }
        }
        return empty;
    }

    private static List<String> filter(List<String> options, String token) {
        String t = token.toLowerCase(Locale.ROOT);
        return options.stream().filter(s -> s.toLowerCase(Locale.ROOT).startsWith(t)).collect(Collectors.toList());
    }

    private boolean isModern() {
        String version = Bukkit.getBukkitVersion();
        String[] parts = version.split("-")[0].split("\\.");
        int major = Integer.parseInt(parts[0]);
        int minor = Integer.parseInt(parts[1]);
        return major > 1 || major == 1 && minor >= 14;
    }

    private static class NoPermission
    extends Exception {
        private NoPermission() {
        }
    }
}

