/*
 * Decompiled with CFR 0.152.
 */
package de.astranox.simpleprefix.handlers;

import de.astranox.simpleprefix.SimplePrefix;
import de.astranox.simpleprefix.managers.ConfigManager;
import de.astranox.simpleprefix.managers.GroupManager;
import de.astranox.simpleprefix.managers.TeamManager;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class ConfigWatcher {
    private final SimplePrefix plugin;
    private final ConfigManager configManager;
    private final GroupManager groupManager;
    private final TeamManager teamManager;
    private WatchService watchService;
    private Thread watchThread;
    private final Map<String, Long> lastModified = new HashMap<String, Long>();
    private static final long DEBOUNCE_TIME = 1000L;
    private final AtomicBoolean isSaving = new AtomicBoolean(false);

    public ConfigWatcher(SimplePrefix plugin, ConfigManager configManager, GroupManager groupManager, TeamManager teamManager) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.groupManager = groupManager;
        this.teamManager = teamManager;
    }

    public void setSaving(boolean saving) {
        this.isSaving.set(saving);
    }

    public void start() {
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
            Path configPath = this.plugin.getDataFolder().toPath();
            if (!Files.exists(configPath, new LinkOption[0])) {
                this.plugin.getLogger().warning("Config directory does not exist!");
                return;
            }
            configPath.register(this.watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE);
            this.watchThread = new Thread(this::watch, "SimplePrefix-ConfigWatcher");
            this.watchThread.setDaemon(true);
            this.watchThread.start();
            this.plugin.getLogger().info("Config watcher started successfully!");
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to start config watcher!");
            e.printStackTrace();
        }
    }

    public void stop() {
        if (this.watchThread != null && this.watchThread.isAlive()) {
            this.watchThread.interrupt();
            this.plugin.getLogger().info("Config watcher stopped!");
        }
        if (this.watchService != null) {
            try {
                this.watchService.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void watch() {
        this.plugin.getLogger().info("Config watcher thread started!");
        while (!Thread.interrupted()) {
            try {
                WatchKey key = this.watchService.poll(1L, TimeUnit.SECONDS);
                if (key == null) continue;
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) {
                        this.plugin.getLogger().warning("Config watcher overflow!");
                        continue;
                    }
                    Path changed = (Path)event.context();
                    String fileName = changed.toString();
                    if (!this.shouldProcess(fileName)) continue;
                    if (this.isSaving.get()) {
                        if (!this.configManager.getConfig().getBoolean("settings.debug", false)) continue;
                        this.plugin.getLogger().info("Ignoring change in " + fileName + " (currently saving)");
                        continue;
                    }
                    this.plugin.getLogger().info("Detected external change in: " + fileName);
                    if (fileName.equals("config.yml")) {
                        this.handleConfigChange();
                    }
                    if (!fileName.equals("groups.yml")) continue;
                    this.handleGroupsChange();
                }
                boolean valid = key.reset();
                if (valid) continue;
                this.plugin.getLogger().warning("Config watcher key no longer valid!");
                break;
            }
            catch (InterruptedException e) {
                this.plugin.getLogger().info("Config watcher interrupted!");
                break;
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error in config watcher: " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.plugin.getLogger().info("Config watcher thread stopped!");
    }

    private boolean shouldProcess(String fileName) {
        if (fileName.endsWith(".tmp") || fileName.endsWith(".swp") || fileName.startsWith(".")) {
            return false;
        }
        if (!fileName.equals("config.yml") && !fileName.equals("groups.yml")) {
            return false;
        }
        long now = System.currentTimeMillis();
        Long last = this.lastModified.get(fileName);
        if (last != null && now - last < 1000L) {
            return false;
        }
        this.lastModified.put(fileName, now);
        return true;
    }

    private void handleConfigChange() {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            try {
                this.plugin.getLogger().info("Reloading config.yml...");
                this.configManager.reloadConfig();
                this.plugin.updateAllPlayers();
                this.plugin.getLogger().info("Config reloaded and players updated!");
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error reloading config: " + e.getMessage());
                e.printStackTrace();
            }
        }, 10L);
    }

    private void handleGroupsChange() {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            try {
                this.plugin.getLogger().info("Reloading groups.yml...");
                this.groupManager.reloadGroups();
                this.plugin.updateAllPlayers();
                this.plugin.getLogger().info("Groups reloaded and players updated!");
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error reloading groups: " + e.getMessage());
                e.printStackTrace();
            }
        }, 10L);
    }
}

