/*
 * Decompiled with CFR 0.152.
 */
package de.astranox.simpleprefix.handlers;

import de.astranox.simpleprefix.SimplePrefix;
import de.astranox.simpleprefix.managers.ConfigManager;
import de.astranox.simpleprefix.managers.GroupManager;
import de.astranox.simpleprefix.managers.LuckPermsWrapper;
import de.astranox.simpleprefix.managers.TabChatManager;
import de.astranox.simpleprefix.managers.TeamManager;
import java.util.UUID;
import net.luckperms.api.event.EventBus;
import net.luckperms.api.event.group.GroupDataRecalculateEvent;
import net.luckperms.api.event.node.NodeAddEvent;
import net.luckperms.api.event.node.NodeRemoveEvent;
import net.luckperms.api.event.user.UserDataRecalculateEvent;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class LuckPermsEventHandler {
    private final SimplePrefix plugin;
    private final LuckPermsWrapper luckPermsWrapper;
    private final TeamManager teamManager;
    private final TabChatManager chatManager;
    private final ConfigManager configManager;
    private final GroupManager groupManager;

    public LuckPermsEventHandler(SimplePrefix plugin, LuckPermsWrapper luckPermsWrapper, TeamManager teamManager, TabChatManager chatManager, ConfigManager configManager, GroupManager groupManager) {
        this.plugin = plugin;
        this.luckPermsWrapper = luckPermsWrapper;
        this.teamManager = teamManager;
        this.chatManager = chatManager;
        this.configManager = configManager;
        this.groupManager = groupManager;
    }

    public void register() {
        EventBus eventBus = this.luckPermsWrapper.getLuckPerms().getEventBus();
        eventBus.subscribe((Object)this.plugin, UserDataRecalculateEvent.class, this::onUserDataRecalculate);
        eventBus.subscribe((Object)this.plugin, NodeAddEvent.class, this::onNodeAdd);
        eventBus.subscribe((Object)this.plugin, NodeRemoveEvent.class, this::onNodeRemove);
        eventBus.subscribe((Object)this.plugin, GroupDataRecalculateEvent.class, this::onGroupDataRecalculate);
        this.plugin.getLogger().info("LuckPerms event listeners registered!");
    }

    private void onUserDataRecalculate(UserDataRecalculateEvent event) {
        if (!this.configManager.isAutoUpdateEnabled()) {
            return;
        }
        UUID uuid = event.getUser().getUniqueId();
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null || !player.isOnline()) {
                return;
            }
            this.teamManager.updatePlayerTeam(player);
            this.chatManager.updatePlayerListName(player);
            if (this.configManager.isDebugEnabled()) {
                this.plugin.getLogger().info("Auto-updated " + player.getName() + " (Data recalculated)");
            }
        });
    }

    private void onNodeAdd(NodeAddEvent event) {
        if (!this.configManager.isAutoUpdateEnabled()) {
            return;
        }
        if (event.getTarget() instanceof User) {
            User user = (User)event.getTarget();
            this.handleNodeChange(user.getUniqueId(), "Node added");
        }
        if (event.getTarget() instanceof Group) {
            Group group = (Group)event.getTarget();
            this.handleGroupChange(group.getName(), "Node added to group", true);
        }
    }

    private void onNodeRemove(NodeRemoveEvent event) {
        if (!this.configManager.isAutoUpdateEnabled()) {
            return;
        }
        if (event.getTarget() instanceof User) {
            User user = (User)event.getTarget();
            this.handleNodeChange(user.getUniqueId(), "Node removed");
        }
        if (event.getTarget() instanceof Group) {
            Group group = (Group)event.getTarget();
            this.handleGroupChange(group.getName(), "Node removed from group", true);
        }
    }

    private void onGroupDataRecalculate(GroupDataRecalculateEvent event) {
        if (!this.configManager.isAutoUpdateEnabled()) {
            return;
        }
        this.handleGroupChange(event.getGroup().getName(), "Group data recalculated", true);
    }

    private void handleNodeChange(UUID uuid, String reason) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null || !player.isOnline()) {
                return;
            }
            this.teamManager.updatePlayerTeam(player);
            this.chatManager.updatePlayerListName(player);
            if (this.configManager.isDebugEnabled()) {
                this.plugin.getLogger().info("Auto-updated " + player.getName() + " (" + reason + ")");
            }
        }, 5L);
    }

    private void handleGroupChange(String groupName, String reason, boolean saveToConfig) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            GroupManager.GroupData groupData;
            if (saveToConfig && (groupData = this.groupManager.getGroup(groupName)) != null) {
                this.groupManager.saveToConfig(groupName);
                if (this.configManager.isDebugEnabled()) {
                    this.plugin.getLogger().info("Auto-saved group '" + groupName + "' to config");
                }
            }
            int updatedCount = 0;
            for (Player player : Bukkit.getOnlinePlayers()) {
                String primaryGroup = this.luckPermsWrapper.getPrimaryGroup(player);
                if (!primaryGroup.equalsIgnoreCase(groupName)) continue;
                this.teamManager.updatePlayerTeam(player);
                this.chatManager.updatePlayerListName(player);
                ++updatedCount;
            }
            if (this.configManager.isDebugEnabled() && updatedCount > 0) {
                this.plugin.getLogger().info("Auto-updated " + updatedCount + " players in group '" + groupName + "' (" + reason + ")");
            }
        }, 10L);
    }
}

