/*
 * Decompiled with CFR 0.152.
 */
package de.astranox.simpleprefix.managers;

import de.astranox.simpleprefix.SimplePrefix;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final SimplePrefix plugin;
    private FileConfiguration config;
    private File configFile;
    private long lastModified;

    public ConfigManager(SimplePrefix plugin) {
        this.plugin = plugin;
    }

    public void loadConfigs() {
        this.plugin.saveDefaultConfig();
        this.config = this.plugin.getConfig();
        this.configFile = new File(this.plugin.getDataFolder(), "config.yml");
        this.lastModified = this.configFile.lastModified();
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.lastModified = this.configFile.lastModified();
        this.plugin.getLogger().info("Config reloaded!");
    }

    public boolean checkAndReload() {
        long current = this.configFile.lastModified();
        if (current <= this.lastModified) {
            return false;
        }
        this.reloadConfig();
        return true;
    }

    public boolean isAutoReloadEnabled() {
        return this.config.getBoolean("settings.auto-reload.enabled", true);
    }

    public int getReloadInterval() {
        return this.config.getInt("settings.auto-reload.interval", 30);
    }

    public long getJoinDelay() {
        return this.config.getLong("settings.join-delay", 20L);
    }

    public String getTeamPrefix() {
        return this.config.getString("settings.team-prefix", "lp_");
    }

    public boolean isDebugEnabled() {
        return this.config.getBoolean("settings.debug", false);
    }

    public boolean isAutoUpdateEnabled() {
        return this.config.getBoolean("settings.auto-update.enabled", true);
    }

    public boolean isChatFormatEnabled() {
        return this.config.getBoolean("formats.chat.enabled", true);
    }

    public String getChatFormat() {
        return this.config.getString("formats.chat.format", "{prefix}{player}{suffix}: {message}");
    }

    public void setChatFormat(String format) {
        this.config.set("formats.chat.format", (Object)format);
        this.saveConfig();
    }

    public void setChatEnabled(boolean enabled) {
        this.config.set("formats.chat.enabled", (Object)enabled);
        this.saveConfig();
    }

    public boolean isTabFormatEnabled() {
        return this.config.getBoolean("formats.tab.enabled", true);
    }

    public String getTabFormat() {
        return this.config.getString("formats.tab.format", "{prefix}{player}{suffix}");
    }

    public void setTabFormat(String format) {
        this.config.set("formats.tab.format", (Object)format);
        this.saveConfig();
    }

    public void setTabEnabled(boolean enabled) {
        this.config.set("formats.tab.enabled", (Object)enabled);
        this.saveConfig();
    }

    private void saveConfig() {
        try {
            this.config.save(this.configFile);
            this.lastModified = this.configFile.lastModified();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getMessage(String path) {
        return this.config.getString("messages." + path, "").replace('&', '\u00a7');
    }

    public FileConfiguration getConfig() {
        return this.config;
    }
}

