/*
 * Decompiled with CFR 0.152.
 */
package de.astranox.simpleprefix.managers;

import de.astranox.simpleprefix.SimplePrefix;
import de.astranox.simpleprefix.managers.LuckPermsWrapper;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class GroupManager {
    private final SimplePrefix plugin;
    private final LuckPermsWrapper luckPermsWrapper;
    private final boolean useLuckPerms;
    private File groupsFile;
    private FileConfiguration groupsConfig;
    private long lastModified;

    public GroupManager(SimplePrefix plugin, LuckPermsWrapper luckPermsWrapper, boolean useLuckPerms) {
        this.plugin = plugin;
        this.luckPermsWrapper = luckPermsWrapper;
        this.useLuckPerms = useLuckPerms;
    }

    public void loadGroups() {
        this.groupsFile = new File(this.plugin.getDataFolder(), "groups.yml");
        if (!this.groupsFile.exists()) {
            this.plugin.saveResource("groups.yml", false);
        }
        this.groupsConfig = YamlConfiguration.loadConfiguration((File)this.groupsFile);
        this.lastModified = this.groupsFile.lastModified();
        if (this.useLuckPerms) {
            this.applyConfigOverridesToLuckPerms();
        }
    }

    public void reloadGroups() {
        this.groupsConfig = YamlConfiguration.loadConfiguration((File)this.groupsFile);
        this.lastModified = this.groupsFile.lastModified();
        if (this.useLuckPerms) {
            this.applyConfigOverridesToLuckPerms();
        }
        this.plugin.getLogger().info("Groups config reloaded" + (this.useLuckPerms ? " and synced to LuckPerms!" : "!"));
    }

    public boolean checkAndReload() {
        long current = this.groupsFile.lastModified();
        if (current <= this.lastModified) {
            return false;
        }
        this.reloadGroups();
        return true;
    }

    public boolean createGroup(String groupName, String prefix, String suffix, int priority, String nameColor) {
        if (this.groupExists(groupName)) {
            this.plugin.getLogger().warning("Group '" + groupName + "' already exists!");
            return false;
        }
        if (this.useLuckPerms && this.luckPermsWrapper != null) {
            boolean created = this.luckPermsWrapper.createGroup(groupName);
            if (!created) {
                this.plugin.getLogger().severe("Failed to create group '" + groupName + "' in LuckPerms!");
                return false;
            }
            this.luckPermsWrapper.setGroupPrefix(groupName, prefix, priority);
            this.luckPermsWrapper.setGroupSuffix(groupName, suffix, priority);
            this.plugin.getLogger().info("Created group '" + groupName + "' in LuckPerms!");
        }
        this.saveToConfig(groupName, prefix, suffix, priority, nameColor);
        this.plugin.getLogger().info("Created group '" + groupName + "' in SimplePrefix!");
        return true;
    }

    public boolean groupExists(String groupName) {
        if (this.useLuckPerms && this.luckPermsWrapper != null) {
            return this.luckPermsWrapper.groupExists(groupName);
        }
        return this.groupsConfig.getConfigurationSection("groups." + groupName) != null;
    }

    public boolean deleteGroupCompletely(String groupName) {
        boolean deleted;
        if (groupName.equalsIgnoreCase("default")) {
            this.plugin.getLogger().warning("Cannot delete default group!");
            return false;
        }
        if (!this.groupExists(groupName)) {
            this.plugin.getLogger().warning("Group '" + groupName + "' does not exist!");
            return false;
        }
        if (this.useLuckPerms && this.luckPermsWrapper != null && (deleted = this.luckPermsWrapper.deleteGroup(groupName))) {
            this.plugin.getLogger().info("Deleted group '" + groupName + "' from LuckPerms!");
        }
        this.groupsConfig.set("groups." + groupName, null);
        try {
            this.groupsConfig.save(this.groupsFile);
            this.lastModified = this.groupsFile.lastModified();
            this.plugin.getLogger().info("Deleted group '" + groupName + "' from SimplePrefix!");
            return true;
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save groups.yml!");
            e.printStackTrace();
            return false;
        }
    }

    public void applyConfigOverridesToLuckPerms() {
        if (!this.useLuckPerms || this.luckPermsWrapper == null) {
            return;
        }
        ConfigurationSection groups = this.groupsConfig.getConfigurationSection("groups");
        if (groups == null) {
            this.plugin.getLogger().warning("No groups section found in groups.yml!");
            return;
        }
        int count = 0;
        for (String groupName : groups.getKeys(false)) {
            String prefix = groups.getString(groupName + ".prefix");
            String suffix = groups.getString(groupName + ".suffix");
            int priority = groups.getInt(groupName + ".priority", 0);
            if (!this.luckPermsWrapper.groupExists(groupName)) {
                this.plugin.getLogger().warning("Group '" + groupName + "' does not exist in LuckPerms!");
                continue;
            }
            boolean prefixSuccess = this.luckPermsWrapper.setGroupPrefix(groupName, prefix, priority);
            boolean suffixSuccess = this.luckPermsWrapper.setGroupSuffix(groupName, suffix, priority);
            if (!prefixSuccess && !suffixSuccess) continue;
            ++count;
        }
        this.plugin.getLogger().info("Applied " + count + " group overrides to LuckPerms!");
    }

    public Map<String, GroupData> getAllGroups() {
        HashMap<String, GroupData> result = new HashMap<String, GroupData>();
        ConfigurationSection groups = this.groupsConfig.getConfigurationSection("groups");
        if (groups == null) {
            return result;
        }
        for (String groupName : groups.getKeys(false)) {
            String prefix = groups.getString(groupName + ".prefix", "");
            String suffix = groups.getString(groupName + ".suffix", "");
            int priority = groups.getInt(groupName + ".priority", 999);
            String nameColor = groups.getString(groupName + ".nameColor");
            result.put(groupName, new GroupData(prefix, suffix, priority, nameColor));
        }
        return result;
    }

    public GroupData getGroup(String groupName) {
        ConfigurationSection groupSection = this.groupsConfig.getConfigurationSection("groups." + groupName);
        if (groupSection == null) {
            return null;
        }
        String prefix = groupSection.getString("prefix", "");
        String suffix = groupSection.getString("suffix", "");
        int priority = groupSection.getInt("priority", 999);
        String nameColor = groupSection.getString("nameColor");
        return new GroupData(prefix, suffix, priority, nameColor);
    }

    public void setGroup(String groupName, String prefix, String suffix, int priority) {
        this.setGroup(groupName, prefix, suffix, priority, null);
    }

    public void setGroup(String groupName, String prefix, String suffix, int priority, String nameColor) {
        if (this.useLuckPerms && this.luckPermsWrapper != null) {
            if (!this.luckPermsWrapper.groupExists(groupName)) {
                this.plugin.getLogger().warning("Group '" + groupName + "' does not exist in LuckPerms!");
            } else {
                this.luckPermsWrapper.setGroupPrefix(groupName, prefix, priority);
                this.luckPermsWrapper.setGroupSuffix(groupName, suffix, priority);
            }
        }
        this.saveToConfig(groupName, prefix, suffix, priority, nameColor);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.plugin.updateAllPlayers(), 10L);
    }

    public void deleteGroup(String groupName) {
        if (this.useLuckPerms && this.luckPermsWrapper != null && this.luckPermsWrapper.groupExists(groupName)) {
            this.luckPermsWrapper.setGroupPrefix(groupName, "", 0);
            this.luckPermsWrapper.setGroupSuffix(groupName, "", 0);
        }
        this.groupsConfig.set("groups." + groupName, null);
        try {
            this.groupsConfig.save(this.groupsFile);
            this.lastModified = this.groupsFile.lastModified();
            this.plugin.getLogger().info("Removed group '" + groupName + "' from config!");
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save groups.yml!");
            e.printStackTrace();
        }
    }

    public void saveToConfig(String groupName) {
        GroupData data = this.getGroup(groupName);
        if (data == null) {
            this.plugin.getLogger().warning("Group '" + groupName + "' not found!");
            return;
        }
        this.saveToConfig(groupName, data.prefix, data.suffix, data.priority, data.nameColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToConfig(String groupName, String prefix, String suffix, int priority, String nameColor) {
        if (this.plugin.getConfigWatcher() != null) {
            this.plugin.getConfigWatcher().setSaving(true);
        }
        this.groupsConfig.set("groups." + groupName + ".prefix", (Object)(prefix != null && !prefix.isEmpty() ? prefix : ""));
        this.groupsConfig.set("groups." + groupName + ".suffix", (Object)(suffix != null && !suffix.isEmpty() ? suffix : ""));
        this.groupsConfig.set("groups." + groupName + ".priority", (Object)priority);
        if (nameColor != null && !nameColor.isEmpty()) {
            this.groupsConfig.set("groups." + groupName + ".nameColor", (Object)nameColor);
        }
        try {
            this.groupsConfig.save(this.groupsFile);
            this.lastModified = this.groupsFile.lastModified();
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("Saved group '" + groupName + "' to config!");
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save groups.yml!");
            e.printStackTrace();
        }
        finally {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (this.plugin.getConfigWatcher() != null) {
                    this.plugin.getConfigWatcher().setSaving(false);
                }
            }, 5L);
        }
    }

    public static class GroupData {
        public final String prefix;
        public final String suffix;
        public final int priority;
        public final String nameColor;

        public GroupData(String prefix, String suffix, int priority) {
            this(prefix, suffix, priority, null);
        }

        public GroupData(String prefix, String suffix, int priority, String nameColor) {
            this.prefix = prefix;
            this.suffix = suffix;
            this.priority = priority;
            this.nameColor = nameColor;
        }
    }
}

