/*
 * Decompiled with CFR 0.152.
 */
package de.astranox.simpleprefix.managers;

import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.PrefixNode;
import net.luckperms.api.node.types.SuffixNode;
import org.bukkit.entity.Player;

public class LuckPermsWrapper {
    private final LuckPerms luckPerms = LuckPermsProvider.get();

    public String getPrimaryGroup(Player player) {
        User user = this.luckPerms.getPlayerAdapter(Player.class).getUser((Object)player);
        if (user == null) {
            return "default";
        }
        return user.getPrimaryGroup();
    }

    public boolean createGroup(String groupName) {
        if (this.groupExists(groupName)) {
            return false;
        }
        try {
            this.luckPerms.getGroupManager().createAndLoadGroup(groupName).join();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setGroupPrefix(String groupName, String prefix, int priority) {
        Group group = this.luckPerms.getGroupManager().getGroup(groupName);
        if (group == null) {
            return false;
        }
        group.data().clear(node -> node instanceof PrefixNode);
        if (prefix != null && !prefix.isEmpty()) {
            group.data().add((Node)PrefixNode.builder((String)prefix, (int)priority).build());
        }
        this.luckPerms.getGroupManager().saveGroup(group);
        return true;
    }

    public boolean setGroupSuffix(String groupName, String suffix, int priority) {
        Group group = this.luckPerms.getGroupManager().getGroup(groupName);
        if (group == null) {
            return false;
        }
        group.data().clear(node -> node instanceof SuffixNode);
        if (suffix != null && !suffix.isEmpty()) {
            group.data().add((Node)SuffixNode.builder((String)suffix, (int)priority).build());
        }
        this.luckPerms.getGroupManager().saveGroup(group);
        return true;
    }

    public boolean deleteGroup(String groupName) {
        if (!this.groupExists(groupName)) {
            return false;
        }
        if (groupName.equalsIgnoreCase("default")) {
            return false;
        }
        try {
            this.luckPerms.getGroupManager().deleteGroup(this.luckPerms.getGroupManager().getGroup(groupName)).join();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean groupExists(String groupName) {
        return this.luckPerms.getGroupManager().getGroup(groupName) != null;
    }

    public LuckPerms getLuckPerms() {
        return this.luckPerms;
    }
}

