/*
 * Decompiled with CFR 0.152.
 */
package de.astranox.simpleprefix.managers;

import de.astranox.simpleprefix.SimplePrefix;
import de.astranox.simpleprefix.managers.ConfigManager;
import de.astranox.simpleprefix.managers.GroupManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class MigrationManager {
    private final SimplePrefix plugin;
    private final GroupManager groupManager;
    private final ConfigManager configManager;

    public MigrationManager(SimplePrefix plugin, GroupManager groupManager, ConfigManager configManager) {
        this.plugin = plugin;
        this.groupManager = groupManager;
        this.configManager = configManager;
    }

    public MigrationResult migrateLuckPrefix() {
        File luckPrefixFolder = new File(this.plugin.getDataFolder().getParentFile(), "LuckPrefix");
        File luckPrefixGroupsFile = new File(luckPrefixFolder, "groups.yml");
        if (!luckPrefixGroupsFile.exists()) {
            return new MigrationResult(false, 0, "LuckPrefix groups.yml not found at: " + luckPrefixGroupsFile.getAbsolutePath());
        }
        try {
            YamlConfiguration luckPrefixConfig = YamlConfiguration.loadConfiguration((File)luckPrefixGroupsFile);
            Set groups = luckPrefixConfig.getKeys(false);
            if (groups.isEmpty()) {
                return new MigrationResult(false, 0, "No groups found in LuckPrefix config");
            }
            String migratedChatFormat = null;
            String migratedTabFormat = null;
            int migratedCount = 0;
            int skippedCount = 0;
            LinkedHashMap<String, String> details = new LinkedHashMap<String, String>();
            for (String groupName : groups) {
                ConfigurationSection groupSection = luckPrefixConfig.getConfigurationSection(groupName);
                if (groupSection == null) {
                    ++skippedCount;
                    details.put(groupName, "Empty/null group");
                    this.plugin.getLogger().info("Skipping group '" + groupName + "': null section");
                    continue;
                }
                String prefix = groupSection.getString("Prefix", "");
                String suffix = groupSection.getString("Suffix", "");
                int sortId = groupSection.getInt("SortID", 999);
                String nameColor = groupSection.getString("NameColor", "");
                String chatFormat = groupSection.getString("Chatformat", "");
                String tabFormat = groupSection.getString("Tabformat", "");
                if (migratedChatFormat == null && chatFormat != null && !chatFormat.trim().isEmpty()) {
                    migratedChatFormat = this.convertFormat(chatFormat);
                    this.plugin.getLogger().info("Migrating chat format from group '" + groupName + "': " + migratedChatFormat);
                }
                if (migratedTabFormat == null && tabFormat != null && !tabFormat.trim().isEmpty()) {
                    migratedTabFormat = this.convertFormat(tabFormat);
                    this.plugin.getLogger().info("Migrating tab format from group '" + groupName + "': " + migratedTabFormat);
                }
                if ((prefix == null || prefix.trim().isEmpty()) && (suffix == null || suffix.trim().isEmpty())) {
                    ++skippedCount;
                    details.put(groupName, "No prefix/suffix (empty)");
                    this.plugin.getLogger().info("Skipping group '" + groupName + "': no prefix or suffix");
                    continue;
                }
                int priority = sortId;
                this.plugin.getLogger().info("Migrating '" + groupName + "': prefix='" + prefix + "', suffix='" + suffix + "', sortId=" + sortId + " \u2192 priority=" + priority + ", nameColor=" + nameColor);
                this.groupManager.setGroup(groupName, prefix, suffix, priority, nameColor);
                details.put(groupName, "\u2713 Migrated (Priority: " + priority + ")");
                ++migratedCount;
            }
            if (migratedChatFormat != null) {
                this.configManager.setChatFormat(migratedChatFormat);
                details.put("[Chat Format]", "\u2713 Migrated: " + migratedChatFormat);
                this.plugin.getLogger().info("Chat format migrated successfully!");
            }
            if (migratedTabFormat != null) {
                this.configManager.setTabFormat(migratedTabFormat);
                details.put("[Tab Format]", "\u2713 Migrated: " + migratedTabFormat);
                this.plugin.getLogger().info("Tab format migrated successfully!");
            }
            String message = "Migrated " + migratedCount + " groups";
            if (skippedCount > 0) {
                message = message + " (skipped " + skippedCount + " empty groups)";
            }
            if (migratedChatFormat != null || migratedTabFormat != null) {
                message = message + " and formats";
            }
            return new MigrationResult(true, migratedCount, message, details);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error during migration: " + e.getMessage());
            e.printStackTrace();
            return new MigrationResult(false, 0, "Migration failed: " + e.getMessage());
        }
    }

    private String convertFormat(String format) {
        if (format == null || format.isEmpty()) {
            return "";
        }
        format = format.replace("<prefix>", "{prefix}");
        format = format.replace("<suffix>", "{suffix}");
        format = format.replace("<player>", "{player}");
        format = format.replace("<displayname>", "{displayname}");
        format = format.replace("<message>", "{message}");
        return format;
    }

    public MigrationResult cleanupEmptyGroups() {
        try {
            Map<String, GroupManager.GroupData> allGroups = this.groupManager.getAllGroups();
            int removedCount = 0;
            ArrayList<String> removedGroups = new ArrayList<String>();
            for (Map.Entry<String, GroupManager.GroupData> entry : allGroups.entrySet()) {
                boolean suffixEmpty;
                String groupName = entry.getKey();
                GroupManager.GroupData data = entry.getValue();
                boolean prefixEmpty = data.prefix == null || data.prefix.trim().isEmpty();
                boolean bl = suffixEmpty = data.suffix == null || data.suffix.trim().isEmpty();
                if (!prefixEmpty || !suffixEmpty) continue;
                this.groupManager.deleteGroup(groupName);
                removedGroups.add(groupName);
                ++removedCount;
                this.plugin.getLogger().info("Removed empty group: " + groupName);
            }
            if (removedCount == 0) {
                return new MigrationResult(true, 0, "No empty groups found to cleanup");
            }
            LinkedHashMap<String, String> details = new LinkedHashMap<String, String>();
            for (String group : removedGroups) {
                details.put(group, "Removed");
            }
            return new MigrationResult(true, removedCount, "Cleaned up " + removedCount + " empty groups", details);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error during cleanup: " + e.getMessage());
            e.printStackTrace();
            return new MigrationResult(false, 0, "Cleanup failed: " + e.getMessage());
        }
    }

    public static class MigrationResult {
        public final boolean success;
        public final int migratedCount;
        public final String message;
        public final Map<String, String> details;

        public MigrationResult(boolean success, int migratedCount, String message) {
            this(success, migratedCount, message, new HashMap<String, String>());
        }

        public MigrationResult(boolean success, int migratedCount, String message, Map<String, String> details) {
            this.success = success;
            this.migratedCount = migratedCount;
            this.message = message;
            this.details = details;
        }
    }
}

