/*
 * Decompiled with CFR 0.152.
 */
package de.astranox.simpleprefix.managers;

import de.astranox.simpleprefix.SimplePrefix;
import de.astranox.simpleprefix.managers.GroupManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class PermissionGroupResolver {
    private final SimplePrefix plugin;
    private final GroupManager groupManager;

    public PermissionGroupResolver(SimplePrefix plugin, GroupManager groupManager) {
        this.plugin = plugin;
        this.groupManager = groupManager;
    }

    public String resolveGroup(Player player) {
        Map<String, GroupManager.GroupData> allGroups = this.groupManager.getAllGroups();
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("=== Resolving group for " + player.getName() + " ===");
            this.plugin.getLogger().info("Available groups in config: " + allGroups.keySet());
            this.plugin.getLogger().info("Player's effective permissions:");
            for (PermissionAttachmentInfo perm : player.getEffectivePermissions()) {
                if (!perm.getPermission().startsWith("simpleprefix.group.")) continue;
                this.plugin.getLogger().info("  - " + perm.getPermission() + " = " + perm.getValue());
            }
        }
        ArrayList<GroupEntry> matchedGroups = new ArrayList<GroupEntry>();
        for (Map.Entry<String, GroupManager.GroupData> entry : allGroups.entrySet()) {
            String groupName = entry.getKey();
            GroupManager.GroupData data = entry.getValue();
            String permission = "simpleprefix.group." + groupName.toLowerCase();
            if (!player.hasPermission(permission)) continue;
            matchedGroups.add(new GroupEntry(groupName, data.priority));
            if (!this.plugin.getConfigManager().isDebugEnabled()) continue;
            this.plugin.getLogger().info("  \u2713 Matched group: " + groupName + " (priority: " + data.priority + ")");
        }
        if (matchedGroups.isEmpty()) {
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("  ! No groups matched, using default");
            }
            return "default";
        }
        matchedGroups.sort(Comparator.comparingInt(e -> e.priority));
        String resolvedGroup = ((GroupEntry)matchedGroups.get((int)0)).groupName;
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("  \u2192 Resolved to: " + resolvedGroup + " (priority: " + ((GroupEntry)matchedGroups.get((int)0)).priority + ")");
            if (matchedGroups.size() > 1) {
                this.plugin.getLogger().info("  (Player has " + matchedGroups.size() + " groups, showing highest priority)");
            }
        }
        return resolvedGroup;
    }

    private static class GroupEntry {
        final String groupName;
        final int priority;

        GroupEntry(String groupName, int priority) {
            this.groupName = groupName;
            this.priority = priority;
        }
    }
}

