/*
 * Decompiled with CFR 0.152.
 */
package de.astranox.simpleprefix.util;

import java.util.regex.Pattern;

public class BukkitColor {
    public static final char COLOR_CHAR = '\u00a7';
    public static final char REPLACEMENT_CHAR = '&';
    public static final String ALL_CODES = "0123456789AaBbCcDdEefKkLlMmNnOoRrXx";
    public static final Pattern STRIP_COLOR_PATTERN = Pattern.compile("(?i)" + String.valueOf('\u00a7') + "[0-9A-FK-ORX]");
    public static final Pattern STRIP_UNCOLORED_PATTERN = Pattern.compile("(?i)" + String.valueOf('&') + "[0-9A-FK-ORX]");

    private BukkitColor() {
    }

    public static String strip(String text) {
        return text == null ? null : STRIP_COLOR_PATTERN.matcher(text).replaceAll("");
    }

    public static String stripPlain(String text) {
        return text == null ? null : STRIP_UNCOLORED_PATTERN.matcher(text).replaceAll("");
    }

    public static String apply(String text) {
        char[] chars = text.toCharArray();
        for (int i = 0; i < chars.length - 1; ++i) {
            if (chars[i] != '&' || ALL_CODES.indexOf(chars[i + 1]) <= -1) continue;
            chars[i] = 167;
            chars[i + 1] = Character.toLowerCase(chars[i + 1]);
        }
        return new String(chars);
    }

    public static String unapply(String text) {
        char[] chars = text.toCharArray();
        for (int i = 0; i < chars.length - 1; ++i) {
            if (chars[i] != '\u00a7' || ALL_CODES.indexOf(chars[i + 1]) <= -1) continue;
            chars[i] = 38;
            chars[i + 1] = Character.toLowerCase(chars[i + 1]);
        }
        return new String(chars);
    }
}

