/*
 * Decompiled with CFR 0.152.
 */
package de.astranox.simpleprefix.util;

import de.astranox.simpleprefix.SimplePrefix;
import de.astranox.simpleprefix.util.BukkitColor;
import de.astranox.simpleprefix.util.VersionUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class ComponentParser {
    private final SimplePrefix plugin;
    private final MiniMessage miniMessage;

    public ComponentParser(SimplePrefix plugin) {
        this.plugin = plugin;
        this.miniMessage = MiniMessage.miniMessage();
    }

    public String parse(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        try {
            Object component = this.miniMessage.deserialize(text);
            String legacy = LegacyComponentSerializer.legacySection().serialize((Component)component);
            if (VersionUtil.isLegacyVersion()) {
                legacy = legacy.replaceAll("(?i)(\u00a7x(\u00a7[0-9A-F]){6})", "");
                legacy = legacy.replaceAll("(?i)\u00a7[lmnok]", "");
            }
            return BukkitColor.apply(legacy);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("ComponentParser error for: " + text);
            e.printStackTrace();
            return text.replaceAll("<[^>]*>", "");
        }
    }
}

